library('deSolve')

# derivative functions for the resource competition model
Monod_derivatives = function(t,X,parms)
  {
  n = dim(parms$h)[1]
  m = dim(parms$h)[2]
  N = X[1:n]
  R = X[(n+1):(n+m)]
  dNdt = numeric(n)
  for ( i in 1:n )
    dNdt[i] = with(parms,N[i]*min(r[i,]*R/(h[i,]+R)-D))
  dRdt = numeric(m)
  for ( j in 1:m )
    dRdt[j] = with(parms,D*(S[j]-R[j])-sum((dNdt+N*D)*Q[,j]))
  return(list(c(dNdt,dRdt)))
  }

# specify model parameters
n = 2; m = 2
parms = list(D=0.25, S=c(41.3,0.58),
  r=t(matrix(c(1.11,0.65,0.62,0.80),n,m)),
  h=t(matrix(c(19.7,0.003,1.5,0.011),n,m)),
  Q=t(matrix(c(5.8e-5,1.1e-7,9.7e-7,4.7e-8),n,m)))

# initial condition
X0 = c(1000*10^1.9,1000*10^2.9,41.3,0.58)

# times at which to evaluate the values of our variables
ts=seq(0,30,length.out=100)

# run the differential equation solver to get time series
X_t = ode(X0,ts,Monod_derivatives,parms=parms)

# plot the results
plot(X_t) 
